document.addEventListener('DOMContentLoaded', () => {
    let cart = [];
    const vouchers = {
        'SALE10': 0.10, // Giảm 10%
        'SALE20': 0.20, // Giảm 20%
        'SALE30': 0.30, // Giảm 30%
        'SALE40': 0.40, // Giảm 40%
        'SALE50': 0.50, // Giảm 50%
        'SALE60': 0.60, // Giảm 60%
        'SALE70': 0.70, // Giảm 70%
        'SALE80': 0.80, // Giảm 80%
        'SALE90': 0.90, // Giảm 90%
        'FREESHIP': 'freeship', // Voucher miễn phí vận chuyển
        'CARDSALESSJ': 0.97 // Giảm 90%

    };
    let appliedVoucher = null;
    const shippingFee = 0; // Phí vận chuyển mặc định

    const cartItemsDiv = document.getElementById('cartItems');
    const subtotalAmountSpan = document.getElementById('subtotalAmount');
    const shippingFeeAmountSpan = document.getElementById('shippingFeeAmount');
    const discountAmountSpan = document.getElementById('discountAmount');
    const totalAmountSpan = document.getElementById('totalAmount');
    const voucherInput = document.getElementById('voucherInput');
    const applyVoucherBtn = document.getElementById('applyVoucherBtn');
    const cartItemCountSpan = document.getElementById('cartItemCount'); // For header count
    const toastContainer = document.getElementById('toastContainer');
    const randomProductsGrid = document.getElementById('randomProductsGrid'); // Make sure this element exists in your HTML

    // Hàm hiển thị thông báo toast
    function showToast(message, duration = 3000) {
        const toast = document.createElement('div');
        toast.classList.add('toast-message');
        toast.textContent = message;

        toastContainer.appendChild(toast);

        setTimeout(() => {
            toast.remove();
        }, duration + 500);
    }

    // Hàm lấy giỏ hàng từ Local Storage
    function getCartFromLocalStorage() {
        const cartString = localStorage.getItem('cart');
        return cartString ? JSON.parse(cartString) : [];
    }

    // Hàm lưu giỏ hàng vào Local Storage
    function saveCartToLocalStorage(cart) {
        localStorage.setItem('cart', JSON.stringify(cart));
    }

    // Cập nhật số lượng sản phẩm trên icon giỏ hàng
    function updateCartItemCount() {
        const cart = getCartFromLocalStorage();
        const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
        cartItemCountSpan.textContent = totalItems;
    }

    // Hàm hiển thị giỏ hàng
    function displayCart() {
        cart = getCartFromLocalStorage(); // Lấy giỏ hàng mới nhất
        cartItemsDiv.innerHTML = ''; // Xóa nội dung cũ

        if (cart.length === 0) {
            cartItemsDiv.innerHTML = '<p>Giỏ hàng trống.</p>';
            document.querySelector('.checkout-action-buttons .btn-checkout').classList.add('disabled'); // Vô hiệu hóa nút thanh toán
            document.querySelector('.checkout-action-buttons .btn-checkout').style.pointerEvents = 'none';
            document.querySelector('.checkout-action-buttons .btn-checkout').style.opacity = '0.6';
        } else {
            document.querySelector('.checkout-action-buttons .btn-checkout').classList.remove('disabled');
            document.querySelector('.checkout-action-buttons .btn-checkout').style.pointerEvents = 'auto';
            document.querySelector('.checkout-action-buttons .btn-checkout').style.opacity = '1';

            cart.forEach(item => {
                const cartItem = document.createElement('div');
                cartItem.classList.add('cart-item');
                cartItem.dataset.uniqueId = item.uniqueId; // Để dễ dàng tìm kiếm khi xóa/cập nhật

                cartItem.innerHTML = `
                    <img src="${item.image}" alt="${item.name}" class="cart-item-image">
                    <div class="cart-item-details">
                        <div class="item-name">${item.name}</div>
                        <img src="https://down-th.img.susercontent.com/file/th-11134258-7rasb-m66ni8frsoaf15" alt="" style="width: 70%;height: 70%"> <br>
                        <span class="HrzuLB XyrmVS" style="color: rgb(238, 77, 45); border-color: rgb(238, 77, 45);">0% SPayLater (สูงสุด 5 เดือน)</span>
                    </div>
                    <div class="cart-item-details">

                     <div class="item-options">ตัวเลือกสินค้า: ${item.color|| 'N/A'},${item.size || 'N/A'}</div>
                  </div>

                  <div class="cart-item-details">

                    <div class="cart-item-price">${(item.price).toLocaleString('th-TH', { style: 'currency', currency: 'THB' })}</div>

                  </div>

                    <div class="cart-item-quantity-control">
                        <button class="decrease-quantity">-</button>
                        <input type="number" value="${item.quantity}" min="1" class="item-quantity-input" readonly>
                        <button class="increase-quantity">+</button>
                    </div>
                     <div class="cart-item-price">${(item.price * item.quantity).toLocaleString('th-TH', { style: 'currency', currency: 'THB' })}</div>
                    <div class="cart-item-remove">
                        <button><i class="fas fa-trash"></i></button>
                    </div>
                `;
                cartItemsDiv.appendChild(cartItem);
            });
        }
        attachCartItemListeners();
        calculateTotal();
        updateCartItemCount();
    }

    // Gán sự kiện cho các nút trong giỏ hàng
    function attachCartItemListeners() {
        document.querySelectorAll('.cart-item').forEach(cartItem => {
            const uniqueId = cartItem.dataset.uniqueId;
            const quantityInput = cartItem.querySelector('.item-quantity-input');

            // Decrease quantity
            cartItem.querySelector('.decrease-quantity').addEventListener('click', () => {
                let currentQty = parseInt(quantityInput.value);
                if (currentQty > 1) {
                    currentQty--;
                    updateCartItemQuantity(uniqueId, currentQty);
                } else {
                    // Nếu số lượng là 1 và nhấn giảm, hỏi xóa sản phẩm
                    if (confirm('Bạn có muốn xóa sản phẩm này khỏi giỏ hàng?')) {
                        removeFromCart(uniqueId);
                    }
                }
            });

            // Increase quantity
            cartItem.querySelector('.increase-quantity').addEventListener('click', () => {
                let currentQty = parseInt(quantityInput.value);
                currentQty++;
                updateCartItemQuantity(uniqueId, currentQty);
            });

            // Remove item
            cartItem.querySelector('.cart-item-remove button').addEventListener('click', () => {
                if (confirm('Bạn có muốn xóa sản phẩm này khỏi giỏ hàng?')) {
                    removeFromCart(uniqueId);
                }
            });
        });
    }

    // Cập nhật số lượng sản phẩm trong giỏ hàng
    function updateCartItemQuantity(uniqueId, newQuantity) {
        const itemIndex = cart.findIndex(item => item.uniqueId === uniqueId);
        if (itemIndex > -1) {
            cart[itemIndex].quantity = newQuantity;
            saveCartToLocalStorage(cart);
            displayCart(); // Render lại giỏ hàng
        }
    }

    // Xóa sản phẩm khỏi giỏ hàng
    function removeFromCart(uniqueId) {
        cart = cart.filter(item => item.uniqueId !== uniqueId);
        saveCartToLocalStorage(cart);
        displayCart(); // Render lại giỏ hàng
        showToast('Sản phẩm đã được xóa khỏi giỏ hàng!');
    }

    // Hàm tính toán tổng tiền
    function calculateTotal() {
        let subtotal = cart.reduce((sum, item) => sum + (item.price * item.quantity), 0);
        let currentShippingFee = shippingFee;
        let discountAmount = 0;

        if (appliedVoucher) {
            const voucherValue = vouchers[appliedVoucher];
            if (typeof voucherValue === 'number' && voucherValue < 1) { // Voucher giảm giá phần trăm
                discountAmount = subtotal * voucherValue;
            } else if (typeof voucherValue === 'number' && voucherValue >= 1) { // Voucher giảm giá cố định
                discountAmount = voucherValue;
            } else if (voucherValue === 'freeship') { // Voucher freeship
                currentShippingFee = 0;
            }
        }

        let total = subtotal - discountAmount + currentShippingFee;
        if (total < 0) total = 0; // Đảm bảo tổng tiền không âm

        // Cập nhật hiển thị tổng tiền
        subtotalAmountSpan.textContent = subtotal.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });
        shippingFeeAmountSpan.textContent = currentShippingFee.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });
        discountAmountSpan.textContent = discountAmount.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });
        totalAmountSpan.textContent = total.toLocaleString('th-TH', { style: 'currency', currency: 'THB' });

        // Lưu thông tin tổng kết vào session storage để trang checkout có thể dùng
        sessionStorage.setItem('orderSummary', JSON.stringify({
            subtotal: subtotal,
            shippingFee: currentShippingFee,
            discount: discountAmount,
            total: total,
            appliedVoucherCode: appliedVoucher // Lưu mã voucher để hiện trên trang checkout
        }));
    }

    // --- NEW FUNCTION: Display Random Products ---
    function displayRandomProducts() {
        const allProducts = JSON.parse(localStorage.getItem('allProducts') || '[]');
        if (allProducts.length === 0) {
            randomProductsGrid.innerHTML = '<p>ไม่มีสินค้าที่แนะนำ</p>'; // No recommended products
            return;
        }

        // Shuffle products and pick 4 random ones (originally 6, changed to 4 as per your code)
        const shuffledProducts = allProducts.sort(() => 0.5 - Math.random());
        const productsToDisplay = shuffledProducts.slice(0, 4);

        randomProductsGrid.innerHTML = ''; // Clear previous content

        productsToDisplay.forEach(product => {
            const productItem = document.createElement('div');
            productItem.classList.add('product-item'); // Reuse product-item class for styling
            productItem.innerHTML = `
                <div class="product-image-wrapper">
                    <img src="${product.image}" alt="${product.name}">
                </div>
                <div class="product-info">
                    <h3>${product.name}</h3>
                    <p class="price">${product.price.toLocaleString('th-TH', { style: 'currency', currency: 'THB' })}</p>
                    <button class="add-to-cart-btn-random" data-id="${product.id}">เพิ่มลงรถเข็น</button> </div>
            `;
            randomProductsGrid.appendChild(productItem);
        });

        // Add event listeners for "Add to Cart" buttons on random products
        document.querySelectorAll('.add-to-cart-btn-random').forEach(button => {
            button.addEventListener('click', (e) => {
                e.stopPropagation();
                const productId = parseInt(e.target.dataset.id);
                const product = allProducts.find(p => p.id === productId);

                if (product) {
                    let defaultColor = 'N/A';
                    let defaultSize = 'N/A';
                    if (product.variants && product.variants.length > 0) {
                        defaultColor = product.variants[0].color || 'N/A';
                        defaultSize = product.variants[0].sizes && product.variants[0].sizes.length > 0 ? product.variants[0].sizes[0] : 'N/A';
                    }
                    // Assuming you have an addToCart function defined elsewhere or will add it.
                    // For now, this will just call a placeholder.
                    // You need to implement or adapt your existing addToCart logic here.
                    // Example placeholder:
                    function addToCart(productId, color, size) {
                        console.log(`Adding product ${productId}, color ${color}, size ${size} to cart.`);
                        // Your actual add to cart logic would go here, which updates `cart` and `localStorage`
                        // and then calls `displayCart()` and `showToast()`.
                        // For a quick fix, you might want to directly add to cart and update display:
                        const existingCart = getCartFromLocalStorage();
                        const itemToAdd = {
                            id: product.id, // Assuming 'id' is consistent
                            name: product.name,
                            price: product.price,
                            image: product.image,
                            color: color,
                            size: size,
                            quantity: 1, // Add one by default
                            uniqueId: `${product.id}-${color}-${size}` // Unique ID for variations
                        };

                        const existingItemIndex = existingCart.findIndex(item => item.uniqueId === itemToAdd.uniqueId);

                        if (existingItemIndex > -1) {
                            existingCart[existingItemIndex].quantity++;
                        } else {
                            existingCart.push(itemToAdd);
                        }
                        saveCartToLocalStorage(existingCart);
                        displayCart(); // Re-render cart
                        showToast('สินค้าถูกเพิ่มลงในรถเข็น!'); // Product added to cart!
                    }
                    addToCart(product.id, defaultColor, defaultSize);
                }
            });
        });

        // Add click listener for product items to navigate to detail page
        document.querySelectorAll('.random-products-section .product-item').forEach(item => {
            item.addEventListener('click', (e) => {
                if (e.target.classList.contains('add-to-cart-btn-random')) {
                    return;
                }
                const productId = parseInt(item.querySelector('.add-to-cart-btn-random').dataset.id);
                window.location.href = `product-detail.html?id=${productId}`;
            });
        });
    }

    // Khởi tạo hiển thị khi tải trang
    displayCart();
    displayRandomProducts(); // NEW: Call to display random products

    // Sự kiện áp dụng voucher - MOVED INSIDE DOMContentLoaded
    applyVoucherBtn.addEventListener('click', () => {
        const voucherCode = voucherInput.value.trim().toUpperCase();
        if (vouchers[voucherCode]) {
            appliedVoucher = voucherCode; // Lưu mã voucher
            let message = `Mã giảm giá "${voucherCode}" đã được áp dụng!`;
            showToast(message);
            calculateTotal();
        } else {
            showToast('Mã giảm giá không hợp lệ hoặc đã hết hạn.');
            appliedVoucher = null; // Xóa voucher đã áp dụng nếu không hợp lệ
            calculateTotal();
        }
    });
});